#! /usr/bin/ksh

#------------------------------------------------------------------
#Obtencion de fecha y hora actuales
#------------------------------------------------------------------
DATE="`date +%d%m%Y`"
TIME="`date +%H%M%S`"

DATE_TRAZA="`date +%d/%m/%Y`"
TIME_TRAZA="`date +%H:%M:%S`"

#==========================================
#  Parametros de CONFIGURACION
#==========================================
#Nombre de este proceso batch
NOMBRE_PROCESO='AB18AINFOR.sh'
#Descripcion de este proceso batch
DESCRIPCION_PROCESO='RECIBIR INFORMACION BOLETINES'
#Clase java principal que se ejecuta en este proceso batch 
CLASE_JAVA=com.ejie.ab18a.recogidaInformacion.Ab18aRecogidaInformacionBoletines
#Fichero de log del resultado de la ejecucion
NOMBRE_LOG=ab18aRecogidaInformacionBoletines_${DATE}${TIME}.log
LOG_FILE=/datos/ab18a/log/ab18aRecogidaInformacionBoletines_${DATE}${TIME}.log
#Classpath del proceso
#CLASSPATH_JAVA_PROCESO=$ORACLE_HOME/jdbc/lib/ojdbc14.jar:$ORACLE_HOME/jdbc/lib/nls_charset12.jar:/aplic/ab18a/lib/log4j-1.2.16.jar:/aplic/ab18a/lib/esentool-rest-client-2.3.0.jar:/aplic/ab18a/lib/httpclient-4.4.1.jar:/aplic/ab18a/lib/httpcore-4.4.6.jar:/aplic/ab18a/lib/jackson-annotations-2.5.3.jar:/aplic/ab18a/lib/jackson-core-2.5.3.jar:/aplic/ab18a/lib/jackson-databind-2.5.3.jar:/aplic/ab18a/lib/ojdbc6.jar
CLASSPATH_JAVA_PROCESO=/aplic/ab18a/lib/log4j-1.2.16.jar:/aplic/ab18a/lib/esentool-rest-client-2.3.0.jar:/aplic/ab18a/lib/httpclient-4.4.1.jar:/aplic/ab18a/lib/httpcore-4.4.6.jar:/aplic/ab18a/lib/jackson-annotations-2.5.3.jar:/aplic/ab18a/lib/jackson-core-2.5.3.jar:/aplic/ab18a/lib/jackson-databind-2.5.3.jar:/aplic/ab18a/lib/ojdbc6.jar:/aplic/ab18a/lib/commons-codec-1.10.jar:/aplic/ab18a/lib/commons-io-2.5.jar:/aplic/ab18a/lib/commons-lang3-3.5.jar:/aplic/ab18a/lib/commons-logging-1.2.jar:/aplic/ab18a/lib/slf4j-api-1.6.2.jar:/aplic/ab18a/lib/slf4j-log4j12-1.6.2.jar:/aplic/ab18a/lib/Saxon-HE-9.6.0-1.jar:/aplic/ab18a/dist/ab18a.jar
# -----------------------------------------------------
# Iniciar el proceso batch
# -----------------------------------------------------
# Introducir cabecera
echo " "
echo "${DATE_TRAZA} ${TIME_TRAZA} --> Comienzo de la ejecucion del proceso batch java AB18A ($DESCRIPCION_PROCESO) a las: `date`" >> $LOG_FILE


#-----------------------------------------------------------------------
# Para el objeto de seguridad XL-NETS
echo "${DATE_TRAZA} ${TIME_TRAZA} --> Obteniendo parametros para conexion a bbdd de la seguridad XL-NETS..." >> $LOG_FILE
#CONSULTA BD BOLETINES
. /aplic/n38/cade/n38bd 34963 01 STRING

 echo "${DATE_TRAZA} ${TIME_TRAZA} --> Recogido objeto de seguridad XL-NETS" >> $LOG_FILE

STAT=$?
if [ $STAT != 0 ]; then
   echo "${DATE_TRAZA} ${TIME_TRAZA} --> El objeto de seguridad no es v�lido."
   read resp
   exit 1
else
   echo "${DATE_TRAZA} ${TIME_TRAZA} --> Parametros para conexion a bbdd obtenidos correctamente." >> $LOG_FILE
   DNSBD_REGISTRO=`echo $STRING |cut -d '#' -f1`
   USUARIOBD_REGISTRO=`echo $STRING |cut -d '#' -f2`
   PASSWORDBD_REGISTRO=`echo $STRING |cut -d '#' -f3`
fi

#Cadena de conexion a la BBDD de Perfil
URL_CON_BD_REGISTRO="jdbc:oracle:thin:@"$DNSBD_REGISTRO



# ------------------------------------------------------------------


# Lanzado proceso
echo "${DATE_TRAZA} ${TIME_TRAZA} --> Lanzando el proceso. Espere unos segundos ..." >> $LOG_FILE

#Lanzamiento del batch
$JAVA_HOME/bin/java -Xms1024m -Xmx32768m -d64 -cp $CLASSPATH_JAVA_PROCESO $CLASE_JAVA "$URL_CON_BD_REGISTRO" "$USUARIOBD_REGISTRO" "$PASSWORDBD_REGISTRO" >> $LOG_FILE

echo " " >> $LOG_FILE

# Recoger resultado
cSTATUS=${?}
echo "${DATE_TRAZA} ${TIME_TRAZA} --> Proceso clase java terminado. Resultado:$cSTATUS." >> $LOG_FILE
if [ $cSTATUS != 0 ]; then	
	echo "${DATE_TRAZA} ${TIME_TRAZA} --> El proceso de ($DESCRIPCION_PROCESO) no ha finalizado correctamente." >> $LOG_FILE
	echo "${DATE_TRAZA} ${TIME_TRAZA} --> Comprobar fichero de datos ($LOG_FILE) para detectar errores." >> $LOG_FILE
    exit 1
else
	echo "${DATE_TRAZA} ${TIME_TRAZA} --> Proceso AB18A ($DESCRIPCION_PROCESO) finalizado correctamente." >> $LOG_FILE
	exit 0 
fi





